import { Input, type InputConfig } from "./utils/input";
import { Output } from "./utils/output";
import type { BaseConnection, FormatConfig } from "./utils/BaseConnection";
import type { AgentAudioEvent, InterruptionEvent } from "./utils/events";
import { BaseConversation, type Options, type PartialOptions } from "./BaseConversation";
export declare class VoiceConversation extends BaseConversation {
    input: Input;
    output: Output;
    wakeLock: WakeLockSentinel | null;
    static startSession(options: PartialOptions): Promise<VoiceConversation>;
    private inputFrequencyData?;
    private outputFrequencyData?;
    protected constructor(options: Options, connection: BaseConnection, input: Input, output: Output, wakeLock: WakeLockSentinel | null);
    protected handleEndSession(): Promise<void>;
    protected handleInterruption(event: InterruptionEvent): void;
    protected handleAudio(event: AgentAudioEvent): void;
    private onInputWorkletMessage;
    private onOutputWorkletMessage;
    private addAudioBase64Chunk;
    private fadeOutAudio;
    private calculateVolume;
    setMicMuted(isMuted: boolean): void;
    getInputByteFrequencyData(): Uint8Array<ArrayBuffer>;
    getOutputByteFrequencyData(): Uint8Array<ArrayBuffer>;
    getInputVolume(): number;
    getOutputVolume(): number;
    changeInputDevice({ sampleRate, format, preferHeadphonesForIosDevices, inputDeviceId, }: FormatConfig & InputConfig): Promise<Input>;
    changeOutputDevice({ sampleRate, format, outputDeviceId, }: FormatConfig): Promise<Output>;
    setVolume: ({ volume }: {
        volume: number;
    }) => void;
}
